package gov.va.vamf.scheduling.facility.domain;

import com.agilex.healthcare.veteranappointment.domain.VARDomainTransferObjectCollection;
import com.agilex.healthcare.veteranappointment.domain.Namespace;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "cdwfacilities", namespace = Namespace.VeteranAppointmentRequest)
public class CDWFacilities extends VARDomainTransferObjectCollection<CDWFacility> {

	private static final long serialVersionUID = -6002151996752387598L;

	@XmlElement(namespace = Namespace.VeteranAppointmentRequest)
	public List<CDWFacility> getFacility() {
		List<CDWFacility> list = new ArrayList<CDWFacility>();
		for (CDWFacility facility : this) {
			list.add(facility);
		}
		return list;
	}
}